var Face_North = COMMAND_FACE_NORTH; 
var Move_North = COMMAND_MOVE_NORTH;

var Face_South = COMMAND_FACE_SOUTH; 
var Move_South = COMMAND_MOVE_SOUTH;

var Face_East  = COMMAND_FACE_EAST; 
var Move_East  = COMMAND_MOVE_EAST;

var Face_West  = COMMAND_FACE_WEST; 
var Move_West  = COMMAND_MOVE_WEST;

var Face_South_West = COMMAND_FACE_SOUTHWEST;
var Face_North_West = COMMAND_FACE_NORTHWEST;

var Face_South_East = COMMAND_FACE_SOUTHEAST;
var Face_North_East = COMMAND_FACE_NORTHEAST;

function Move (name, move, face, times){
  for (j = 0; j < times; j++){
    QueuePersonCommand (name, face, false);
  for (i = 0; i < 16; i++){
    QueuePersonCommand (name, move, false);
  }
 }
}

function Face (name, face){
    QueuePersonCommand (name, face, true);
 }

function Walk_Random (name, waitLength, stepLength){
  if (!waitLength)
    waitLength = 0;
  if (!stepLength)
    stepLength = 1;
  var random = Math.floor(Math.random()*5);
  var action;
  switch (random){
    case (0): action = COMMAND_WAIT; break;
    case (1): action = COMMAND_MOVE_NORTH; break;
    case (2): action = COMMAND_MOVE_EAST; break;
    case (3): action = COMMAND_MOVE_SOUTH; break;
    case (4): action = COMMAND_MOVE_WEST; break;
  }
  switch (action){
    case (COMMAND_WAIT):
      for (var i = 0; i < 16; i++){
        for (var j = 0; j < stepLength; j++){
          QueuePersonCommand (name, action, false);
        }
        for (var j = 0; j < waitLength; j++){
          QueuePersonCommand (name, COMMAND_WAIT, false);
        }
      }
      break;
    case (COMMAND_MOVE_NORTH):
      QueuePersonCommand (name, COMMAND_FACE_NORTH, true);
      for (var i = 0; i < 16; i++){
        for (var j = 0; j < stepLength; j++){
          QueuePersonCommand (name, action, false);
        }
        for(var j = 0; j < waitLength; j++){
          QueuePersonCommand (name, COMMAND_WAIT, false);
        }
      }
      break;
    case (COMMAND_MOVE_EAST):
      QueuePersonCommand (name, COMMAND_FACE_EAST, true);
      for (var i = 0; i < 16; i++){
        for (var j = 0; j < stepLength; j++){
          QueuePersonCommand (name, action, false);
        }
        for (var j = 0; j < waitLength; j++){
          QueuePersonCommand (name, COMMAND_WAIT, false);
        }
      }
      break;
    case (COMMAND_MOVE_SOUTH):
      QueuePersonCommand (name, COMMAND_FACE_SOUTH, true);
      for (var i = 0; i < 16; i++){
        for (var j = 0; j < stepLength; j++){
          QueuePersonCommand (name, action, false);
        }
        for (var j = 0; j < waitLength; j++){
          QueuePersonCommand (name, COMMAND_WAIT, false);
        }
      }
      break;
    case (COMMAND_MOVE_WEST):
      QueuePersonCommand (name, COMMAND_FACE_WEST, true);
      for (var i = 0; i < 16; i++){
        for (var j = 0; j < stepLength; j++){
          QueuePersonCommand (name, action, false);
        }
        for (var j = 0; j < waitLength; j++){
          QueuePersonCommand (name, COMMAND_WAIT, false);
        }
      }
    break;
  }
}

function Face_Player (name)
{
  switch (GetPersonDirection("Player"))
  {
    case "north":{
      SetPersonDirection (name, "south"); 
      break;
    }
    case "south":{
      SetPersonDirection (name, "north");
      break;
    }
    case "east":{
      SetPersonDirection (name, "west");
      break;
    }
    case "west":{
      SetPersonDirection (name, "east");
      break;
    }
    case "northeast":{
      SetPersonDirection (name, "southwest");
      break;
    }
    case "southeast":{
      SetPersonDirection (name, "northwest");
      break;
    }
    case "northwest":{
      SetPersonDirection (name, "southeast");
      break;
    }
    case "southwest":{
      SetPersonDirection (name, "northeast");
      break;
    }
  } 
  return true;
}

